<?php $__env->startSection('title', 'المنيو'); ?>

<?php $__env->startSection('content'); ?>




<header class="bg-white dark:bg-gray-900 shadow-md sticky top-0 z-50 transition-colors duration-300">
    <div class="container mx-auto px-4 py-3">
        <div class="flex items-center justify-between" dir="rtl">
            
            
            <div class="flex items-center gap-3 shrink-0">
                <img src="<?php echo e(asset('img/logo.png')); ?>" alt="شعار" class="h-12 w-auto md:h-16 object-contain">
            </div>

            
            <div class="flex-grow text-center mx-2">
                <h1 class="text-xl md:text-3xl font-bold text-orange-600 dark:text-orange-500 tracking-wide">
                    مشوي وسكر
                </h1>
            </div>

            
            <div class="flex items-center gap-2 shrink-0">
                
                <a href="<?php echo e(asset('menu.pdf')); ?>" target="_blank" class="flex items-center justify-center bg-red-600 hover:bg-red-700 text-white text-xs md:text-sm font-bold py-2 px-3 rounded-lg shadow transition-transform hover:scale-105">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 2H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                    <span class="hidden md:inline">المنيو</span>
                    <span class="md:hidden">PDF</span>
                </a>

                
                <button onclick="toggleTheme()" type="button" class="text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 focus:outline-none focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 rounded-lg text-sm p-2.5 transition-colors">
                    <svg class="w-6 h-6 dark:hidden" fill="currentColor" viewBox="0 0 20 20"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                    <svg class="w-6 h-6 hidden dark:block text-yellow-400" fill="currentColor" viewBox="0 0 20 20"><path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 100 2h1z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>
                </button>
            </div>
        </div>
    </div>
</header>




<div x-data="{ activeCategory: 'all' }">

    
    <div class="text-center pt-8 pb-8 px-4">
        <h2 class="text-3xl md:text-5xl font-extrabold text-gray-800 dark:text-white mb-3 tracking-tight">
            وش بخاطرك <span class="text-orange-600">اليوم؟</span> 😋
        </h2>
        <p class="text-gray-500 dark:text-gray-400 text-sm md:text-lg font-light max-w-2xl mx-auto">
            تصفح المنيو واختار اللي يحبه قلبك من تشكيلتنا المميزة
        </p>
    </div>

    
    <div class="sticky top-[80px] z-40 px-4 mb-10 transition-all duration-300">
        <div class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-md border border-gray-100 dark:border-gray-700 rounded-2xl shadow-lg p-2 overflow-x-auto hide-scrollbar">
            <div class="flex md:justify-center gap-2 min-w-max">
                
                
                <button 
                    @click="activeCategory = 'all'"
                    :class="activeCategory === 'all' 
                        ? 'bg-orange-600 text-white shadow-orange-200 shadow-lg scale-105' 
                        : 'bg-transparent text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700'"
                    class="px-6 py-2.5 rounded-xl transition-all duration-300 text-sm md:text-base font-bold flex items-center gap-2">
                    <span>🍽️</span>
                    <span>الكل</span>
                </button>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        @click="activeCategory = <?php echo e($category->id); ?>"
                        :class="activeCategory === <?php echo e($category->id); ?> 
                            ? 'bg-orange-600 text-white shadow-orange-200 shadow-lg scale-105' 
                            : 'bg-transparent text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700'"
                        class="px-5 py-2.5 rounded-xl transition-all duration-300 text-sm md:text-base font-bold whitespace-nowrap flex items-center gap-2">
                        
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->image): ?>
                             <img src="<?php echo e(asset('storage/' . $category->image)); ?>" class="w-6 h-6 rounded-full object-cover">
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php echo e($category->name); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="container mx-auto px-4 max-w-7xl pb-20">
        <div class="space-y-16">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->products->count() > 0): ?>
                
                <section 
                    x-show="activeCategory === 'all' || activeCategory === <?php echo e($category->id); ?>"
                    x-transition:enter="transition ease-out duration-500"
                    x-transition:enter-start="opacity-0 translate-y-8"
                    x-transition:enter-end="opacity-100 translate-y-0"
                    class="scroll-mt-48">
                    
                    <div class="flex items-center justify-between mb-8">
                        <div class="flex items-center gap-4">
                            <div class="w-1.5 h-8 bg-orange-600 rounded-full"></div>
                            <h3 class="text-2xl md:text-3xl font-bold text-gray-800 dark:text-white">
                                <?php echo e($category->name); ?>

                            </h3>
                        </div>
                        
                        <button 
                            x-show="activeCategory !== 'all'" 
                            @click="activeCategory = 'all'" 
                            x-transition
                            class="text-xs md:text-sm font-bold text-orange-600 dark:text-orange-400 bg-orange-50 dark:bg-orange-900/20 px-4 py-2 rounded-full hover:bg-orange-100 dark:hover:bg-orange-900/40 transition-colors cursor-pointer">
                            عرض بقية المنيو ←
                        </button>
                    </div>

                    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4 md:gap-6">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('item.show', $item->id)); ?>" class="group relative bg-white dark:bg-gray-800 rounded-[2rem] shadow-sm hover:shadow-xl dark:hover:shadow-black/40 transition-all duration-300 border border-gray-100 dark:border-gray-700 overflow-hidden flex flex-col h-full hover:-translate-y-1">
                            
                            
                            <div class="aspect-[4/3] w-full bg-gray-100 dark:bg-gray-700 overflow-hidden relative">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $item->image)); ?>" alt="<?php echo e($item->name); ?>" class="w-full h-full object-cover transition duration-700 group-hover:scale-110">
                                <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center text-gray-300 dark:text-gray-600">
                                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <div class="absolute bottom-3 left-3 translate-y-4 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-300">
                                    <span class="w-10 h-10 bg-white dark:bg-gray-700 text-orange-600 dark:text-orange-400 rounded-full shadow-lg flex items-center justify-center hover:bg-orange-600 hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                                    </span>
                                </div>
                            </div>

                            
                            <div class="p-5 flex flex-col flex-1">
                                <div class="mb-3">
                                    <h4 class="font-bold text-gray-900 dark:text-white text-base md:text-lg mb-1 leading-tight group-hover:text-orange-600 transition-colors">
                                        <?php echo e($item->name); ?>

                                    </h4>
                                    <p class="text-gray-500 dark:text-gray-400 text-xs md:text-sm line-clamp-2 leading-relaxed">
                                        <?php echo e($item->description); ?>

                                    </p>
                                </div>
                                
                                <div class="mt-auto pt-4 border-t border-gray-50 dark:border-gray-700 flex items-center justify-between">
                                    <div class="flex flex-col">
                                        <span class="text-[10px] text-gray-400 font-medium">السعر</span>
                                        <span class="font-bold text-gray-900 dark:text-white text-lg font-mono">
                                            <?php echo e($item->price ?? 'حسب الاختيار'); ?> <span class="text-xs text-orange-600">ر.س</span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </section>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($categories->isEmpty()): ?>
        <div class="text-center py-20">
            <div class="text-6xl mb-4">🍽️</div>
            <h3 class="text-xl font-bold text-gray-800 dark:text-white">المنيو فارغ حالياً</h3>
            <p class="text-gray-500">يرجى العودة لاحقاً</p>
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

</div>




<div class="fixed bottom-6 left-6 z-50" x-data>
    <a href="<?php echo e(route('cart.index')); ?>" class="group flex items-center justify-center w-14 h-14 md:w-16 md:h-16 bg-gray-900 dark:bg-orange-600 text-white rounded-full shadow-[0_8px_30px_rgb(0,0,0,0.3)] hover:scale-110 transition-all duration-300 relative border-2 border-white dark:border-gray-800">
        
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 md:h-7 md:w-7 group-hover:animate-bounce" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
        </svg>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count(session('cart', [])) > 0): ?>
        <span class="absolute -top-2 -right-2 bg-red-600 text-white text-xs md:text-sm font-bold w-6 h-6 md:w-7 md:h-7 flex items-center justify-center rounded-full border-2 border-white dark:border-gray-900 shadow-sm animate-pulse">
            <?php echo e(count(session('cart', []))); ?>

        </span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </a>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/digitizir-mashwiwsukar/htdocs/mashwiwsukar.digitizir.com/resources/views/menu/index.blade.php ENDPATH**/ ?>