<?php $__env->startSection('content'); ?>

<div class="min-h-screen bg-gray-50 dark:bg-gray-900 pb-32" x-data="productCalculator()">

    <div class="relative h-72 md:h-96 bg-gray-200 dark:bg-gray-800">
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($existingItem)): ?>
            <a href="<?php echo e(route('cart.index')); ?>" class="absolute top-6 right-6 z-10 bg-white/20 backdrop-blur-md p-2 rounded-full text-white hover:bg-white/30 transition shadow-lg">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
            </a>
        <?php else: ?>
            <a href="<?php echo e(route('menu.index')); ?>" class="absolute top-6 right-6 z-10 bg-white/20 backdrop-blur-md p-2 rounded-full text-white hover:bg-white/30 transition shadow-lg">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->image): ?>
            <img src="<?php echo e(asset('storage/' . $item->image)); ?>" class="w-full h-full object-cover">
        <?php else: ?>
            <div class="w-full h-full flex items-center justify-center text-gray-400">
                <svg class="w-20 h-20" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <div class="absolute bottom-0 inset-x-0 h-32 bg-gradient-to-t from-gray-900/90 to-transparent"></div>
    </div>

    <div class="container mx-auto px-4 -mt-10 relative z-10">
        <div class="bg-white dark:bg-gray-800 rounded-3xl shadow-xl p-6 border border-gray-100 dark:border-gray-700">
            
            <div class="flex justify-between items-start mb-4">
                <div>
                    <h1 class="text-2xl md:text-3xl font-bold text-gray-800 dark:text-white mb-2"><?php echo e($item->name); ?></h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm leading-relaxed"><?php echo e($item->description); ?></p>
                </div>
                <div class="text-xl font-bold text-orange-600 dark:text-orange-500" x-text="formatMoney(totalPrice)"></div>
            </div>

            <hr class="my-6 border-gray-100 dark:border-gray-700">

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($item->sizes)): ?>
            <div class="mb-8">
                <h3 class="font-bold text-gray-800 dark:text-gray-200 mb-4 flex items-center gap-2"><span>📏</span> اختر الحجم</h3>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button 
                            @click="selectSize('<?php echo e($size['price']); ?>', '<?php echo e($index); ?>', '<?php echo e($size['name']); ?>')"
                            :class="selectedSizeName === '<?php echo e($size['name']); ?>' ? 'border-orange-500 bg-orange-50 dark:bg-orange-900/20 text-orange-700 dark:text-orange-400' : 'border-gray-200 dark:border-gray-600 text-gray-600 dark:text-gray-300 hover:border-orange-300'"
                            class="border-2 rounded-xl p-4 text-center relative transition-all duration-200 group">
                            <span class="block font-bold mb-1"><?php echo e($size['name']); ?></span>
                            <span class="text-sm opacity-80"><?php echo e($size['price']); ?> ر.س</span>
                            <div x-show="selectedSizeName === '<?php echo e($size['name']); ?>'" class="absolute top-2 left-2 text-orange-500">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"></path></svg>
                            </div>
                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->addons->count() > 0): ?>
            <div class="mb-8">
                <h3 class="font-bold text-gray-800 dark:text-gray-200 mb-4 flex items-center gap-2"><span>🧀</span> إضافات</h3>
                <div class="space-y-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="flex items-center justify-between p-3 rounded-xl border border-gray-100 dark:border-gray-700 bg-gray-50 dark:bg-gray-700/30 cursor-pointer hover:bg-orange-50 dark:hover:bg-gray-700 transition">
                        <div class="flex items-center gap-3">
                            <input type="checkbox" 
                                   :checked="selectedAddonsNames.includes('<?php echo e($addon->name); ?>')"
                                   @change="toggleAddon(<?php echo e($addon->price); ?>, '<?php echo e($addon->name); ?>')" 
                                   class="w-5 h-5 text-orange-600 rounded bg-white dark:bg-gray-600 border-gray-300 focus:ring-orange-500">
                            <span class="text-gray-700 dark:text-gray-200 font-medium"><?php echo e($addon->name); ?></span>
                        </div>
                        <span class="text-sm font-bold text-gray-500 dark:text-gray-400">+<?php echo e($addon->price); ?> ر.س</span>
                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->exclusionList && $item->exclusionList->count() > 0): ?>
            <div class="mb-8">
                <h3 class="font-bold text-gray-800 dark:text-gray-200 mb-4 flex items-center gap-2"><span>🚫</span> تعديلات (بدون)</h3>
                <div class="flex flex-wrap gap-2">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->exclusionList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button @click="toggleExclusion('<?php echo e($exclusion->name); ?>')"
                            :class="exclusions.includes('<?php echo e($exclusion->name); ?>') ? 'bg-red-100 text-red-700 border-red-300 dark:bg-red-900/30 dark:text-red-300' : 'bg-gray-100 text-gray-600 border-transparent dark:bg-gray-700 dark:text-gray-300'"
                            class="px-4 py-2 rounded-lg text-sm font-bold border transition-colors flex items-center gap-2">
                            <span x-show="exclusions.includes('<?php echo e($exclusion->name); ?>')">✖</span>
                            <?php echo e($exclusion->name); ?>

                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="mb-6">
                <h3 class="font-bold text-gray-800 dark:text-gray-200 mb-2 flex items-center gap-2"><span>📝</span> ملاحظات للمطبخ</h3>
                <textarea x-model="notes" class="w-full p-4 rounded-xl border border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700 focus:ring-orange-500 focus:border-orange-500 outline-none transition" rows="3" placeholder="مثلاً: كثر صوص..."></textarea>
            </div>
        </div>
    </div>

    <div class="fixed bottom-0 inset-x-0 bg-white dark:bg-gray-800 border-t border-gray-100 dark:border-gray-700 p-4 shadow-[0_-4px_6px_-1px_rgba(0,0,0,0.1)] z-50">
        <div class="container mx-auto max-w-4xl flex items-center justify-between gap-4">
            <div class="flex flex-col">
                <span class="text-xs text-gray-400">الإجمالي</span>
                <span class="text-2xl font-bold text-gray-800 dark:text-white" x-text="formatMoney(totalPrice)"></span>
            </div>
            
            <button @click="addToCartServer()" 
                    :disabled="loading"
                    class="flex-1 bg-orange-600 hover:bg-orange-700 text-white font-bold py-3 px-6 rounded-xl shadow-lg transition transform active:scale-95 flex items-center justify-center gap-2 disabled:opacity-50">
                <span x-show="!loading"><?php echo e(isset($existingItem) ? 'تحديث الطلب' : 'إضافة للسلة'); ?></span>
                <span x-show="loading">جاري التنفيذ...</span>
                <svg x-show="!loading" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
            </button>
        </div>
    </div>

</div>

<script>
    function productCalculator() {
        return {
            basePrice: <?php echo e($item->price ?? 0); ?>,
            sizePrice: 0,
            addonsPrice: 0,
            selectedSizeName: null,
            selectedAddonsNames: [],
            exclusions: [],
            notes: '',
            loading: false,
            quantity: 1,

            // هنا يكمن السحر: تعبئة البيانات إذا كانت موجودة
            init() {
                <?php if(isset($existingItem)): ?>
                    // وضع التعديل
                    this.notes = '<?php echo e($existingItem['notes'] ?? ''); ?>';
                    this.quantity = <?php echo e($existingItem['quantity'] ?? 1); ?>;
                    
                    // استرجاع الاستبعادات
                    this.exclusions = <?php echo json_encode($existingItem['exclusions'] ?? [], 15, 512) ?>;

                    // استرجاع الحجم
                    <?php if($existingItem['variant_label']): ?>
                        this.selectedSizeName = '<?php echo e($existingItem['variant_label']); ?>';
                        // نحتاج لمعرفة سعر الحجم المختار
                        <?php $__currentLoopData = $item->sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            if('<?php echo e($size['name']); ?>' === this.selectedSizeName) {
                                this.sizePrice = parseFloat('<?php echo e($size['price']); ?>');
                            }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        this.basePrice = <?php echo e($item->price ?? 0); ?>;
                    <?php endif; ?>

                    // استرجاع الإضافات
                    let savedAddons = <?php echo json_encode($existingItem['addons'] ?? [], 15, 512) ?>;
                    this.selectedAddonsNames = savedAddons;
                    
                    // إعادة حساب سعر الإضافات
                    <?php $__currentLoopData = $item->addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        if(savedAddons.includes('<?php echo e($addon->name); ?>')) {
                            this.addonsPrice += parseFloat('<?php echo e($addon->price); ?>');
                        }
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php else: ?>
                    // وضع الإضافة الجديد: اختيار أول حجم تلقائياً
                    <?php if(!empty($item->sizes)): ?>
                        this.selectSize('<?php echo e($item->sizes[0]['price']); ?>', '0', '<?php echo e($item->sizes[0]['name']); ?>');
                        this.basePrice = 0; 
                    <?php endif; ?>
                <?php endif; ?>
            },

            selectSize(price, index, name) {
                this.sizePrice = parseFloat(price);
                this.selectedSizeName = name;
            },

            toggleAddon(price, name) {
                let checkbox = this.$event.target;
                if (checkbox.checked) {
                    this.addonsPrice += parseFloat(price);
                    this.selectedAddonsNames.push(name);
                } else {
                    this.addonsPrice -= parseFloat(price);
                    this.selectedAddonsNames = this.selectedAddonsNames.filter(n => n !== name);
                }
            },

            toggleExclusion(name) {
                if (this.exclusions.includes(name)) {
                    this.exclusions = this.exclusions.filter(e => e !== name);
                } else {
                    this.exclusions.push(name);
                }
            },

            addToCartServer() {
                this.loading = true;

                let data = {
                    id: '<?php echo e($item->id); ?>',
                    name: '<?php echo e($item->name); ?>',
                    price: this.totalPrice,
                    variant_label: this.selectedSizeName,
                    addons: this.selectedAddonsNames,
                    exclusions: this.exclusions,
                    notes: this.notes,
                    quantity: this.quantity, // نحافظ على الكمية
                    <?php if(isset($existingItem)): ?>
                        old_key: '<?php echo e($key); ?>' // نرسل مفتاح العنصر القديم لحذفه
                    <?php endif; ?>
                };

                fetch('<?php echo e(route("cart.add")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(data => {
                    if(data.success) {
                        window.location.href = "<?php echo e(route('cart.index')); ?>"; // الرجوع للسلة بعد التعديل
                    } else {
                        alert('حدث خطأ');
                    }
                })
                .finally(() => { this.loading = false; });
            },

            get totalPrice() {
                let productPrice = this.sizePrice > 0 ? this.sizePrice : this.basePrice;
                return (productPrice + this.addonsPrice).toFixed(2);
            },
            
            formatMoney(value) {
                return value + ' ر.س';
            }
        }
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/digitizir-mashwiwsukar/htdocs/mashwiwsukar.digitizir.com/resources/views/menu/item.blade.php ENDPATH**/ ?>