<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\MenuController;

// الروابط الأساسية
Route::get('/', [MenuController::class, 'index'])->name('menu.index');
Route::get('/item/{id}', [MenuController::class, 'showItem'])->name('item.show');
Route::get('/cart', [MenuController::class, 'cartIndex'])->name('cart.index');

// رابط التعديل الجديد 👇
Route::get('/cart/edit/{id}/{key}', [MenuController::class, 'editItem'])->name('cart.edit');

// عمليات السلة
Route::post('/cart/add', [MenuController::class, 'addToCart'])->name('cart.add');
Route::post('/cart/update', [MenuController::class, 'updateCart'])->name('cart.update');
Route::delete('/cart/remove', [MenuController::class, 'removeFromCart'])->name('cart.remove');

// رابط الطوارئ
Route::get('/reset-cart', function() {
    Session::forget('cart');
    Session::save();
    return redirect()->route('menu.index');
});

// الكود السحري
Route::get('/magic-fix', function() {
    Artisan::call('optimize:clear');
    Artisan::call('view:clear');
    return "✅ تم التنظيف";
});