<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('products', function (Blueprint $table) {
        $table->id();
        // هذا السطر يربط المنتج بالقسم
        $table->foreignId('category_id')->constrained('categories')->cascadeOnDelete();
        
        $table->string('name');
        $table->decimal('price', 10, 2);
        $table->string('image')->nullable();
        $table->boolean('is_visible')->default(true);
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
