<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Filament\Models\Contracts\FilamentUser; // 1. استدعاء الواجهة
use Filament\Panel; // 2. استدعاء البانل

class User extends Authenticatable implements FilamentUser // 3. تنفيذ الواجهة
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    // 4. دالة السماح بالدخول في وضع Production
    public function canAccessPanel(Panel $panel): bool
    {
        // السماح فقط لهذا الإيميل بالدخول، ومنع أي شخص آخر
        // (يمكنك تغيير true للسماح للجميع مؤقتاً إذا أردت)
        return $this->email === 'ban@gmail.com' || $this->email === 'admin@admin.com'; 
    }
}