<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Product extends Model
{
    use HasFactory;
    protected $casts = [
    'is_visible' => 'boolean',
    'sizes' => 'array',
    'exclusions' => 'array', // <--- أضف هذا السطر
];
    protected $guarded = [];

    // هذه هي الدالة التي كانت ناقصة وسببت الخطأ
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function addons(): BelongsToMany
    {
        // لاحظ إضافة 'product_addon' هنا
        return $this->belongsToMany(Addon::class, 'product_addon')
            ->withPivot(['price', 'is_available'])
            ->withTimestamps();
    }
    // ... العلاقات السابقة

    // غيرنا الاسم من exclusions إلى exclusionList لتفادي التضارب
    public function exclusionList()
    {
        return $this->belongsToMany(Exclusion::class, 'exclusion_product');
    }
}