<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'name',
        'description',
        'price',
        'image',
        'is_active',
        'sizes',
        'addons',
    ];

    // 🔥 هذا هو الجزء الناقص الذي سيصلح المشكلة 🔥
    protected $casts = [
    'is_active' => 'boolean',
    'sizes' => 'array',   // <--- ضروري
    'addons' => 'array',  // <--- ضروري
];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}