<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Addon extends Model
{
    protected $guarded = [];

    public function category(): BelongsTo
    {
        // تأكد أن الاسم هنا AddonCategory وليس Category
        return $this->belongsTo(AddonCategory::class, 'addon_category_id');
    }

    public function products(): BelongsToMany
    {
        // ولاحظ إضافتها هنا أيضاً
        return $this->belongsToMany(Product::class, 'product_addon')
            ->withPivot(['price', 'is_available'])
            ->withTimestamps();
    }
}