<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use App\Models\Product;  // استدعاء موديل المنتجات
use App\Models\Category; // استدعاء موديل الأقسام

class StatsOverview extends BaseWidget
{
    // تحديث الأرقام كل 15 ثانية
    protected static ?string $pollingInterval = '15s'; 

    protected function getStats(): array
    {
        return [
            // 1. إجمالي الأصناف (الكل: مخفي وظاهر)
            Stat::make('إجمالي الأصناف', Product::count())
                ->description('جميع المنتجات المسجلة')
                ->descriptionIcon('heroicon-m-cube')
                ->color('primary')
                // عرض رسم بياني صغير لآخر 7 منتجات مضافة (جماليات)
                ->chart(Product::query()->latest()->take(7)->pluck('price')->toArray()),

            // 2. متاح للطلب (المنتجات المفعلة فقط)
            Stat::make('متاح للطلب', Product::where('is_visible', true)->count())
                ->description('الوجبات الظاهرة في المنيو')
                ->descriptionIcon('heroicon-m-check-badge')
                ->color('success'),

            // 3. عدد الأقسام
            Stat::make('الأقسام', Category::count())
                ->description('تصنيفات القائمة')
                ->descriptionIcon('heroicon-m-rectangle-stack')
                ->color('warning'),
        ];
    }
}