<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UserResource\Pages;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Hash; // مهم للتشفير

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-users'; // أيقونة المستخدمين
    protected static ?string $navigationLabel = 'المسؤولين';
    protected static ?string $modelLabel = 'مسؤول';
    protected static ?string $pluralModelLabel = 'المسؤولين';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('بيانات المسؤول')
                    ->schema([
                        // الاسم
                        Forms\Components\TextInput::make('name')
                            ->required()
                            ->label('الاسم'),

                        // البريد الإلكتروني
                        Forms\Components\TextInput::make('email')
                            ->email()
                            ->required()
                            ->unique(ignoreRecord: true) // عشان ما يقول الإيميل مستخدم عند التعديل
                            ->label('البريد الإلكتروني'),

                        // كلمة المرور (معالجة خاصة)
                        Forms\Components\TextInput::make('password')
                            ->password()
                            ->label('كلمة المرور')
                            ->dehydrateStateUsing(fn ($state) => Hash::make($state)) // تشفير الباسورد قبل الحفظ
                            ->dehydrated(fn ($state) => filled($state)) // حفظ الباسورد فقط إذا تم كتابته
                            ->required(fn (string $context): bool => $context === 'create'), // مطلوب فقط عند الإنشاء الجديد
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->searchable()
                    ->label('الاسم'),
                
                Tables\Columns\TextColumn::make('email')
                    ->searchable()
                    ->label('البريد الإلكتروني'),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->label('تاريخ الانضمام'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }
}