<?php

namespace App\Filament\Resources\ProductResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;

class AddonsRelationManager extends RelationManager
{
    protected static string $relationship = 'addons';
    protected static ?string $title = 'إضافات هذا المنتج';

    public function form(Form $form): Form
    {
        return $form->schema([]); // لا نحتاج فورم هنا
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')->label('الإضافة'),
                
                // عرض السعر المخصص إن وجد، أو الأصلي
                Tables\Columns\TextColumn::make('price')
                    ->label('سعر البيع')
                    ->formatStateUsing(function (Model $record) {
                        return $record->pivot->price 
                            ? $record->pivot->price . ' (مخصص)' 
                            : $record->price . ' (أصلي)';
                    }),

                // التحكم بالتوفر مباشرة
                Tables\Columns\ToggleColumn::make('is_available')
                    ->label('متاح؟'),
            ])
            ->headerActions([
                Tables\Actions\AttachAction::make()
                    ->preloadRecordSelect()
                    ->label('ربط إضافة')
                    ->form(fn (Tables\Actions\AttachAction $action): array => [
                        $action->getRecordSelect(),
                        Forms\Components\TextInput::make('price')
                            ->label('سعر خاص (اختياري)')
                            ->numeric()
                            ->helperText('اتركه فارغاً لاستخدام سعر الإضافة الأصلي'),
                        Forms\Components\Toggle::make('is_available')
                            ->label('متاح للطلب')
                            ->default(true),
                    ]),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('تعديل السعر')
                    ->form([
                        Forms\Components\TextInput::make('price')->label('السعر الخاص')->numeric(),
                        Forms\Components\Toggle::make('is_available')->label('متاح'),
                    ]),
                Tables\Actions\DetachAction::make()->label('إلغاء الربط'),
            ]);
    }
}