<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ExclusionResource\Pages;
use App\Models\Exclusion;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ExclusionResource extends Resource
{
    protected static ?string $model = Exclusion::class;

    // أيقونة القائمة
    protected static ?string $navigationIcon = 'heroicon-o-no-symbol'; 
    
    // وضعها تحت مجموعة "إدارة المنيو"
    protected static ?string $navigationGroup = 'إدارة المنيو';
    
    // ترتيبها في القائمة
    protected static ?int $navigationSort = 4;

    protected static ?string $modelLabel = 'استبعاد';
    protected static ?string $pluralModelLabel = 'الاستبعادات';
    protected static ?string $navigationLabel = 'الاستبعادات';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('name')
                            ->label('اسم الاستبعاد')
                            ->placeholder('مثلاً: بدون طماطم')
                            ->required()
                            ->maxLength(255),
                        
                        Forms\Components\Toggle::make('is_active')
                            ->label('مفعل')
                            ->default(true),
                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('الاسم')
                    ->searchable(),
                
                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('الحالة'),
            ])
            ->filters([])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
    
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListExclusions::route('/'),
            'create' => Pages\CreateExclusion::route('/create'),
            'edit' => Pages\EditExclusion::route('/{record}/edit'),
        ];
    }
}