<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AddonResource\Pages;
use App\Models\Addon;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class AddonResource extends Resource
{
    protected static ?string $model = Addon::class;
    protected static ?string $navigationIcon = 'heroicon-o-plus-circle';
    protected static ?string $navigationGroup = 'إدارة المنيو';
    protected static ?int $navigationSort = 3;

    // --- التعريب ---
    protected static ?string $modelLabel = 'إضافة';
    protected static ?string $pluralModelLabel = 'الإضافات';
    protected static ?string $navigationLabel = 'الإضافات';
    // --------------

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('بيانات الإضافة')
                    ->schema([
                        Forms\Components\Select::make('addon_category_id')
                            ->relationship('category', 'name')
                            ->label('تصنيف الإضافة')
                            ->createOptionForm([
                                Forms\Components\TextInput::make('name')->required()->label('اسم التصنيف الجديد'),
                            ])
                            ->required(),

                        Forms\Components\TextInput::make('name')
                            ->label('اسم الإضافة')
                            ->required(),

                        Forms\Components\TextInput::make('price')
                            ->label('السعر الافتراضي')
                            ->numeric()
                            ->prefix('SAR')
                            ->required(),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')->label('الإضافة')->searchable(),
                Tables\Columns\TextColumn::make('category.name')->label('التصنيف')->badge()->color('gray'),
                Tables\Columns\TextColumn::make('price')->label('السعر')->money('SAR'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAddons::route('/'),
            'create' => Pages\CreateAddon::route('/create'),
            'edit' => Pages\EditAddon::route('/{record}/edit'),
        ];
    }
    
    public static function getRelations(): array
    {
        return [];
    }
}